/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world.entity;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.util.world.entity.culling.EntityCulling;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionHelper;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class EntityRendering {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer fontRenderer;
    private final RenderManager renderManager;
    private WeakReference<EntityLivingBase> reference;

    public EntityRendering() {
        this.fontRenderer = this.mc.field_71466_p;
        this.renderManager = this.mc.func_175598_ae();
    }

    @SubscribeEvent
    public void cancelRendering(RenderLivingEvent.Pre<? extends EntityLivingBase> event) {
        EntityLivingBase entity = event.entity;
        if (PatcherConfig.disableArmorstands && entity instanceof EntityArmorStand || PatcherConfig.disableSemitransparentEntities && entity.func_82150_aj() && entity instanceof EntityPlayer) {
            event.setCanceled(true);
        }
        if (entity.func_70032_d((Entity)this.mc.field_71439_g) > (float)PatcherConfig.entityRenderDistance && PatcherConfig.entityRenderDistanceToggle && EntityCulling.shouldPerformCulling) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderNametag(RenderLivingEvent.Specials.Pre<EntityPlayerSP> event) {
        if (PatcherConfig.betterHideGui && this.mc.field_71474_y.field_74319_N) {
            return;
        }
        EntityLivingBase entity = event.entity;
        if (entity instanceof EntityPlayerSP && !((EntityPlayerSP)entity).func_175149_v() && !entity.func_82150_aj() && entity.func_70028_i(this.renderManager.field_78734_h) && PatcherConfig.showOwnNametag) {
            this.renderTag(entity);
        }
    }

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent event) {
        if (!PatcherConfig.cleanView) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            EntityLivingBase entity = (EntityLivingBase)this.mc.func_175606_aa();
            EntityLivingBase previousEntity = this.reference != null ? (EntityLivingBase)this.reference.get() : null;
            String key = "0256d9da-9c1b-46ea-a83c-01ae6981a2c8";
            if (previousEntity != entity) {
                if (previousEntity != null && previousEntity.getEntityData().func_74767_n("0256d9da-9c1b-46ea-a83c-01ae6981a2c8")) {
                    Collection effects = previousEntity.func_70651_bq();
                    if (!effects.isEmpty()) {
                        previousEntity.func_70096_w().func_75692_b(7, (Object)PotionHelper.func_77911_a((Collection)effects));
                    }
                    previousEntity.getEntityData().func_82580_o("0256d9da-9c1b-46ea-a83c-01ae6981a2c8");
                }
                WeakReference<EntityLivingBase> weakReference = this.reference = entity != null ? new WeakReference<EntityLivingBase>(entity) : null;
            }
            if (entity != null) {
                entity.func_70096_w().func_75692_b(7, (Object)0);
                if (!entity.getEntityData().func_74767_n("0256d9da-9c1b-46ea-a83c-01ae6981a2c8")) {
                    entity.getEntityData().func_74757_a("0256d9da-9c1b-46ea-a83c-01ae6981a2c8", true);
                }
            }
        }
    }

    private void renderTag(EntityLivingBase entity) {
        String name = entity.func_145748_c_().func_150254_d();
        float nametagScale = 0.02666667f;
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(entity.field_70131_O + 0.5f), (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        int xMultiplier = 1;
        if (this.mc != null && this.mc.field_71474_y != null && this.mc.field_71474_y.field_74320_O == 2) {
            xMultiplier = -1;
        }
        GlStateManager.func_179114_b((float)(this.renderManager.field_78732_j * (float)xMultiplier), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-nametagScale), (float)(-nametagScale), (float)nametagScale);
        if (entity.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)9.374999f, (float)0.0f);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        int stringWidth = this.fontRenderer.func_78256_a(name) / 2;
        if (!PatcherConfig.disableNametagBoxes) {
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f);
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)(-stringWidth - 1), (double)-1.0);
            GL11.glVertex2d((double)(-stringWidth - 1), (double)8.0);
            GL11.glVertex2d((double)(stringWidth + 1), (double)8.0);
            GL11.glVertex2d((double)(stringWidth + 1), (double)-1.0);
            GL11.glEnd();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        if (PatcherConfig.shadowedNametagText) {
            this.fontRenderer.func_175063_a(name, (float)(-stringWidth), 0.0f, entity.func_70093_af() ? 0x20FFFFFF : -1);
        } else {
            this.fontRenderer.func_78276_b(name, -stringWidth, 0, entity.func_70093_af() ? 0x20FFFFFF : -1);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

